#!/bin/sh

# start up memory
# 90 MB

LIMIT_USE_MEMORY_WARNING=260000    # 170000 + 90000 kByte
LIMIT_USE_MEMORY_DEAD_LINE=280000  # 190000 + 90000 kByte
WARNING_MESSAGE_INTERVAL=86400 # 24h


# initialize
LSR901DDISPLAY_PID_WHEN_MESSAGE=0

while :
do
  # command free
  # column free and column buff/cache
  USE_MEMORY=`ps aux | grep 'Storage Card/LSR902/Prg/Lsr901Display' | grep -v grep | awk '{ print $6 }'`
  DATE_TIME=`date '+%Y/%m/%d %H:%M:%S'`
  CURRENT_TIME=`date '+%s'`
  echo ${DATE_TIME} " " ${USE_MEMORY}

  # check free memory limit (dead line)
  if [ ${LIMIT_USE_MEMORY_DEAD_LINE} -lt ${USE_MEMORY} ]; then
    echo show warning \(dead line\) message to Lsr901Display.
    LSR901DDISPLAY_PID_WHEN_MESSAGE=`pidof Lsr901Display`
    dbus-send --system / jp.co.cosmo.leaktester.showFreeMemoryWarning int32:1

    sleep 60

    echo Lsr901Display kill.
    LSR901DDISPLAY_PID_WHEN_BEFORE_KILL=`pidof Lsr901Display`

    if [ ${LSR901DDISPLAY_PID_WHEN_MESSAGE} -eq ${LSR901DDISPLAY_PID_WHEN_BEFORE_KILL} ]; then
      # reboot display automatically because the user has not rebooted
      kill -HUP ${LSR901DDISPLAY_PID_WHEN_BEFORE_KILL}
    fi

    sleep 10

  # check free memory limit
  elif [ ${LIMIT_USE_MEMORY_WARNING} -lt ${USE_MEMORY} -a ${LSR901DDISPLAY_PID_WHEN_MESSAGE} -eq 0  ]; then
    echo show warning message to Lsr901Display.
    dbus-send --system / jp.co.cosmo.leaktester.showFreeMemoryWarning int32:0
    LSR901DDISPLAY_PID_WHEN_MESSAGE=`pidof Lsr901Display`
    WARNING_MESSAGE_SHOW_TIME=`date '+%s'`
  fi

  # check message interval
  if [ -n "${WARNING_MESSAGE_SHOW_TIME}" ]; then
    WARNING_MESSAGE_SHOW_TIME_DIFF=`expr ${CURRENT_TIME} - ${WARNING_MESSAGE_SHOW_TIME}`
    if [ ${WARNING_MESSAGE_SHOW_TIME_DIFF} -gt ${WARNING_MESSAGE_INTERVAL} ]; then
      LSR901DDISPLAY_PID_WHEN_BEFORE_KILL=`pidof Lsr901Display`
      if [ ${LSR901DDISPLAY_PID_WHEN_MESSAGE} -eq ${LSR901DDISPLAY_PID_WHEN_BEFORE_KILL} ]; then
        echo show warning message to Lsr901Display.
        dbus-send --system / jp.co.cosmo.leaktester.showFreeMemoryWarning int32:0
        WARNING_MESSAGE_SHOW_TIME=`date '+%s'`
      else
        WARNING_MESSAGE_SHOW_TIME=""
      fi
    fi
  fi

  sleep 1
done
